﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using Ext.Net;

//setup an alias for all direct method calls on this control
[DirectMethodProxyID(IDMode = DirectMethodProxyIDMode.Alias, Alias = "UCTRENDGRAPH")]

public partial class ucTrendGraph : System.Web.UI.UserControl
{
    public BaseMaster BaseMstr { set; get; }

    protected void Page_Load(object sender, EventArgs e)
    {

    }
    
    /// <summary>
    /// Returns the Scores of the corresponding module.
    /// </summary>
    /// <param name="strPatientID"></param>
    /// <param name="lMID"></param>
    /// <param name="lIntakeID"></param>
    /// <param name="lFilter"></param>
    /// <returns></returns>
    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    public object LoadTrendGraph(string strPatientID, long lMID, long lIntakeID, long lFilter)
    {
        CInstrumentResponse inst = new CInstrumentResponse(BaseMstr);

        return inst.GetInstrumentScoreObj(strPatientID, lMID, lIntakeID, (CInstrumentResponse.ScoreFilter)lFilter);
        
    }
}
